/*
 * Title  : top_cur_dtl.sql
 * Author : EXADIME LLC
 * Created: 06-Jul-2017
 * Updated: 11-Oct-2021
 * Release: 1.0.0
 * Purpose: Shows details of top open cursors.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col hwm_open_cur	format 99,999		heading "HWM"
col max_open_cur	format 99,999		heading "Max"

spool &&rpt_dir/top_cur_dtl.rpt

select 
   max(a.value) as hwm_open_cur, 
   p.value      as max_open_cur
from 
   v$sesstat a, 
   v$statname b, 
   v$parameter p
where 
   a.statistic# = b.statistic# 
and 
   b.name = 'opened cursors current'
and 
   p.name= 'open_cursors'
group by p.value;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off