--
-- Title  : sql_svr_bkp.sql
-- Author : EXADIME LLC
-- Created: 29-Mar-2018
-- Updated: 29-Mar-2018
-- Release: 1.0.0
-- Purpose: This script does SQL Server backup.
-- History: N/A
--

DECLARE @name VARCHAR(50) -- database name  
DECLARE @path VARCHAR(256) -- path for backup files  
DECLARE @fileName VARCHAR(256) -- filename for backup  
DECLARE @fileDate VARCHAR(20) -- used for file name
 
-- Specify database backup directory.
SET @path = '<Backup Directory>'  

-- Specify filename format.
SELECT @fileDate = CONVERT(VARCHAR(20),GETDATE(),112) 
 
DECLARE db_cursor CURSOR FOR  
SELECT name 
FROM master.dbo.sysdatabases 
WHERE name IN ('BEDB') -- Backup only listed databases.
--WHERE name NOT IN ('master','model','msdb','tempdb')  -- Exclude system databases.

OPEN db_cursor   
FETCH NEXT FROM db_cursor INTO @name   
 
WHILE @@FETCH_STATUS = 0   
BEGIN   
       SET @fileName = @path + @name + '_' + @fileDate + '.BAK'  
       BACKUP DATABASE @name TO DISK = @fileName  

 
       FETCH NEXT FROM db_cursor INTO @name   
END   
 
CLOSE db_cursor   
DEALLOCATE db_cursor