/*
 * Title  : sho_exc_pls.sql
 * Author : EXADIME LLC
 * Created: 02-Apr-2018
 * Updated: 02-Apr-2018
 * Release: 1.0.0
 * Purpose: To list the sessions that are currently executing stored code.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column "Type" 		format a9
column "Owner" 		format a30
column "Name" 		format a30
column "SID"		format 9999
column "Serial#"	format 999999

spool &&rpt_dir/sho_exc_pls.rpt

select
	distinct
	decode(
		o.kglobtyp,
		7,'PROCEDURE',
		8,'FUNCTION',
		9,'PACKAGE',
		12,'TRIGGER',
		13,'CLASS'
	)  "Type",
	o.kglnaown  "Owner",
	o.kglnaobj  "Name",
	s.indx  "SID",
	s.ksuseser  "Serial#"
from
	sys.x$kglob  o,
	sys.x$kglpn  p,
	sys.x$ksuse  s
where
	o.inst_id = userenv('Instance')
and	p.inst_id = userenv('Instance')
and	s.inst_id = userenv('Instance')
and	o.kglhdpmd = 2
and	o.kglobtyp in (7, 8, 9, 12, 13)
and	p.kglpnhdl = o.kglhdadr
and	s.addr = p.kglpnses
order by 
	1, 2, 3
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
