/*
 * Title  : rmn_bkp_hist.sql
 * Author : EXADIME LLC
 * Created: 30-Apr-2018
 * Updated: 21-Aug-2022
 * Release: 1.0.0
 * Purpose: Shows RMAN backup details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn	format 99999            heading "#"
column sk	format 99999999999      heading "Session Key"
column it	format a12              heading "Backup Type"
column st	format a19              heading "Start Time"
column et	format a19              heading "End Time"
column ti	format a11              heading "Time"
column sz	format a10              heading "Size"
column sts	format a23              heading "Status"

accept p_type   char prompt "Enter backup type [DB FULL|DB INCR|ARCHIVELOG|SPFILE]: " default "DB FULL','DB INCR','ARCHIVELOG','SPFILE"
accept p_status char prompt "Enter backup status like [RUNNING|COMPLETED|FAILED]: " default ""
accept p_order  char prompt "Enter order by column {1|2|3|4|5|6|7|8} [asc|desc]: " default "session_key desc"
accept p_rows   char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/rmn_bkp_hist.rpt

select
       row_number() over(order by &&p_order)        sn,
       session_key                                  sk,
       input_type                                   it,
       to_char(start_time,'yyyy-mm-dd hh24:mi:ss')  st,
       to_char(end_time,'yyyy-mm-dd hh24:mi:ss')    et,
       time_taken_display                           ti,
       output_bytes_display                         sz,
       status                                       sts
from (
	select 
	       session_key,
	       input_type,
	       start_time,
	       end_time,
	       time_taken_display,
	       output_bytes_display,
	       status
	from 
		v$rman_backup_job_details
	where
		input_type in ('&&p_type')
	and
		status like '%&p_status%'
	order by 
		&&p_order
)
where
	rownum<=&&p_rows;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
