/*
 * Title  : dg_st_mrp.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 08-May-2021
 * Release: 1.0.0
 * Purpose: To start managed recovery process.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_lts char prompt "Enter Log Transport Service {[A]RCH|[L]GWR} " default A

spool &&rpt_dir/dg_st_mrp.rpt

declare
	v_lts varchar2(4):= '&&p_lts';
	v_mrp number:=0;
begin
	select
		count(1) into v_mrp
	from
		v$managed_standby
	where
		process like 'MRP%';

	if v_mrp > 0 then
		dbms_output.put_line('MRP already started!');
	else
		if upper(v_lts) = 'A' or upper(v_lts) = 'ARCH' then
			execute immediate 'alter database recover managed standby database disconnect from session';
			dbms_output.put_line('MRP started using ARCH.');
		elsif upper(v_lts) = 'L' or upper(v_lts) = 'LGWR' then
			execute immediate 'alter database recover managed standby database using current logfile disconnect from session';
			dbms_output.put_line('MRP started using LGWR.');
		else
			dbms_output.put_line('Wrong input!');
		end if;
	end if;
exception
	when others then
		dbms_output.put_line('Failed to start MRP! Details are... ' || chr(10) || SQLERRM );
end;
/

spool off;

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
