/*
 * Title  : cr_view.sql
 * Author : EXADIME LLC
 * Created: 19-Feb-2025
 * Updated: 19-Feb-2025
 * Release: 1.0.0
 * Purpose: Generates view creation script for the given view.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 100000

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

set serveroutput on
execute dbms_output.enable(10000000);

accept p_owner prompt 'Enter owner name: '
accept p_view  prompt 'Enter view name: '

BEGIN
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'SQLTERMINATOR', true);
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'PRETTY', true);
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'SEGMENT_ATTRIBUTES', false);
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'STORAGE', false);
END;
/

spool &&tmp_dir/cr_view.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/cr_view.rpt
prompt 
prompt rem 0.View.
 
select 
	dbms_metadata.get_ddl('VIEW',upper('&&p_view'),upper('&&p_owner')) 
from 
	dual;

prompt
prompt rem 2.Grant view privileges.

select 
	'GRANT '|| privilege || ' ON '|| owner || '.' || table_name || ' TO ' || grantee ||';'
from 
	dba_tab_privs
where
	owner=upper('&&p_owner')
and	table_name = upper('&&p_view');

prompt
prompt spool off
prompt

spool off

prompt Run the script "&&tmp_dir/cr_view.tmp" manually.
prompt

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
