/*
 * Title  : cr_pf.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Generates profile creation script.
 * History: N/A
 */

 start oracle.ini

set echo off
set feedback off
set serverout off
set termout on

set linesize 80
set pagesize 0
set pause off
set long 4000

set heading off
set headsep off
set underline off
set colsep " "

set define on
set verify off
set escape off
set embedded on

set serveroutput on
execute dbms_output.enable(10000000);

spool &&spl_dir/cr_pf.spl

select
	distinct 'select DBMS_METADATA.GET_DDL(''PROFILE'','''|| PROFILE || ''') from dual;'
from
	dba_profiles
where
	profile<>'DEFAULT';

spool off

spool &&tmp_dir/cr_pf.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/cr_pf.rpt
prompt

@@&&spl_dir/cr_pf.spl

prompt
prompt spool off

spool off

prompt Note: Add semi-colon at the end of the each profile creation script.

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
