#!/bin/sh

######################################################################
# Copyright (c)  2013 by Oracle Corporation
# tar_up_partial_archive.sh
# This script tars up some files from an archive directory. You
# can select which files to tar up and send to Oracle Support reducing
# the size of the files which need to be uploaded.
#
# INPUTS:
# $1 = fully qualified path of archive dir
#
# OUTPUTS:
# The output of this utility is osw_archive_MMDDYYHHMM.tar
#######################################################################
echo ""
echo "Usage: ./tar_up_partial_archive.sh <The fully qualified path of the archive directory.>"
count=1

test $1
if [ $? != 1 ]; then
  if [ ! -d $1 ]; then
    echo "The archive directory you specified :"$1" does not exist." 
    exit
  else
   ARCHIVE_FOUND=1
   OSWBB_ARCHIVE_DEST=$1
  fi
else
  echo "Please rerun with archive directory specified"
  exit
fi

echo "Your archive directory contains the following hourly logs"
echo ""

ls -1tr $OSWBB_ARCHIVE_DEST/oswvmstat | \

  while read line
  do
     echo $count:  $line
     count=`expr $count + 1 `
  done

finished=0

while [ $finished != 1 ]
do

  echo ""
  echo "Please enter starting number of log to select for zipping"
  read start
  echo "You selected "$start
  echo ""
  echo "Please enter ending number of log to select for zipping"
  read stop 
  echo "You selected "$stop

  if [ $start -le 0 ]; then
    echo "The value for starting log must be > 0 "
    finished=0
  else
    finished=1

    if [ $stop -le $start ]; then
      echo "The value for ending log must be > value of starting log" 
      finished=0
    else
      finished=1
    fi
  fi
done

rm -rf archive_partial
mkdir archive_partial
mkdir archive_partial/oswvmstat
mkdir archive_partial/oswiostat
mkdir archive_partial/oswtop
mkdir archive_partial/oswmpstat
mkdir archive_partial/oswnetstat
mkdir archive_partial/oswmeminfo
mkdir archive_partial/oswprvtnet
mkdir archive_partial/oswps
mkdir archive_partial/oswslabinfo
mkdir archive_partial/oswnfs
mkdir archive_partial/osw_rds_diagnostics
mkdir archive_partial/osw_ib_diagnostics

count=1

ls -1tr archive/oswvmstat | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswvmstat/$line archive_partial/oswvmstat
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswiostat | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswiostat/$line archive_partial/oswiostat
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswmpstat | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswmpstat/$line archive_partial/oswmpstat
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswtop | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswtop/$line archive_partial/oswtop
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswnetstat | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswnetstat/$line archive_partial/oswnetstat
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswnfs | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswnfs/$line archive_partial/oswnfs
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswmeminfo | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswmeminfo/$line archive_partial/oswmeminfo
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswprvtnet | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswprvtnet/$line archive_partial/oswprvtnet
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswps | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswps/$line archive_partial/oswps
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/oswslabinfo | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/oswslabinfo/$line archive_partial/oswslabinfo
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/osw_rds_diagnostics | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/osw_rds_diagnostics/$line archive_partial/osw_rds_diagnostics
    fi
  fi
  count=`expr $count + 1 `

done

count=1

ls -1tr archive/osw_ib_diagnostics | \
while read line
do
  echo $count:  $line
  if [ $count -ge $start ]; then
    if [ $count -le $stop ]; then
       cp archive/osw_ib_diagnostics/$line archive_partial/osw_ib_diagnostics
    fi
  fi
  count=`expr $count + 1 `

done


tar cvf osw_archive.tar archive_partial
rm -rf archive_partial

hour=`date +'%m%d%y%H%M.tar'`
mv osw_archive.tar osw_archive_$hour



