/*
 * Title  : stat_adv_off.sql
 * Author : EXADIME LLC
 * Created: 06-Jul-2017
 * Updated: 06-Jul-2017
 * Release: 1.0.0
 * Purpose: To disable statistics advisor jobs.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

spool &&rpt_dir/stat_adv_off.rpt

begin
	dbms_auto_task_admin.disable(client_name => 'AUTO SPACE ADVISOR', operation => NULL, window_name => NULL);
	dbms_auto_task_admin.disable(client_name => 'SQL TUNING ADVISOR', operation => NULL, window_name => NULL);
end;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off