/*
 * Title  : sho_tab_priv_user.sql
 * Author : EXADIME LLC
 * Created: 17-Sep-2025
 * Updated: 17-Sep-2025
 * Release: 1.0.0
 * Purpose: Lists all the users that have been granted the tiven table privilege.
 * Comment: Shows only for table privileges.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_owner char prompt 'Enter Table Owner: '
accept p_table char prompt 'Enter Table Name: '
accept p_privilege char prompt 'Enter Privilege Name: '

col sno		format 999	heading "#"
col grantee	format a30      heading "Grantee User"
col description	format a60	heading "Description"

spool &&rpt_dir/sho_tab_priv_user.rpt

select 
	rownum sno,
	grantee,
	privilege || ' ON ' || owner || '.' || table_name description
from(
	select 
		grantee,
		owner,
		table_name,
		privilege
	from 
		dba_tab_privs a,
		dba_users b
	where 
		a.grantee=b.username
	and 	a.owner=upper(trim('&&p_owner'))
	and     a.table_name=upper(trim('&&p_table'))
	and     a.privilege like upper(trim('%&&p_privilege%'))
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
