/*
 * Title  : sho_sys_user.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 13-May-2025
 * Release: 1.0.0
 * Purpose: Shows System Users (12c or above).
 * Comment: Does not work in 11g or below.
 * History: Expiry; Search
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 200
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Serial Number"		format a3
col "User Name"			format a20
col "Default Tablespace"	format a20
col "Temporary Tablespace"	format a20
col "Profile"			format a20
col "Created"			format a10
col "Expiry"			format a10
col "Last Login"                format a20
col "Status"		        format a16

accept p_txt char prompt "Enter search string (E.g. Username): "
accept p_order_col char prompt "Enter order by column {1|2|3|4|5|6|7|8} [asc|desc] " default 2

spool &&rpt_dir/sho_sys_user.rpt

select 
	row_number() over(order by &&p_order_col)       "#",
	username					"User Name",
	default_tablespace				"Default Tablespace",
	temporary_tablespace				"Temporary Tablespace",
	profile						"Profile",
	created						"Created",
	expiry_date					"Expiry",
	to_char(last_login,'DD-MON-YYYY HH24:MI')       "Last Login",
	account_status 					"Status"
from
	dba_users
where
	username in (
		'SYS',
		'SYSTEM',
		'AUDSYS',
		'GSMADMIN_INTERNAL'
		,'GSMCATUSER'
		,'GSMUSER'
		,'OJVMSYS'
		,'SYSBACKUP'
		,'SYSKM'
		,'XS$NULL'
		,'SYSDG',
		'DBSNMP',
		'OUTLN',
		'MDSYS',
		'ORDSYS',
		'ORDPLUGINS',
		'CTXSYS',
		'DSSYS',
		'WKPROXY',
		'WKSYS',
		'WMSYS',
		'XDB',
		'ANONYMOUS',
		'ODM',
		'ODM_MTR',
		'OLAPSYS',
		'TRACESVR',
		'PERFSTAT',
		'REPADMIN',
		'EXFSYS',
		'DMSYS',
		'SYSMAN',
		'DIP',
		'TSMSYS',
		'DVF',
		'DVSYS',
		'WKUSER',
		'WK_TEST',
		'LBACSYS',
		'SI_INFORMTN_SCHEMA',
		'APPQOSSYS',
		'ORACLE_OCM',
		'RMAN',
		'GGS',
		'ORACLE',
		'SYS$UMF',
		'GGSYS',
		'DBSFWUSER',
		'ORADBA',
		'REMOTE_SCHEDULER_AGENT',
		'SYSRAC',
		'ORDDATA',
		'MDDATA'
	)
and
	(username like upper('%&&p_txt%') or default_tablespace like upper('%%p_txt%') or temporary_tablespace like upper('%%p_txt%') or profile like upper('%%p_txt%') or account_status  like upper('%%p_txt%') )
order by
	&&p_order_col
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
