/*
 * Title  : sho_sys_priv_role.sql
 * Author : EXADIME LLC
 * Created: 1-Aug-2017
 * Updated: 1-Aug-2017
 * Release: 1.0.0
 * Purpose: Lists all the roles who have been granted the given system privilege.
 * Comment: Input system privilege only.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_privilege char prompt 'Enter System Privilege Name: '

col sno		format 999              heading "#"
col grantee	format a30	        heading "Grantee Role"

spool &&rpt_dir/sho_sys_priv_role.rpt

select 
	rownum sno,
	grantee
from(
	select 
		grantee 
       from 
		dba_sys_privs a,
		dba_roles b
       where 
		a.grantee=b.role
       and	
		a.privilege=upper('&&p_privilege')
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
