/*
 * Title  : sho_hit_ratio.sql
 * Author : EXADIME LLC
 * Created: 02-Apr-2018
 * Updated: 02-Apr-2018
 * Release: 1.0.0
 * Purpose: To identify the hit ratio.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 50
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col hr format a40 heading "Hit Ratio"

spool &&rpt_dir/sho_hit_ratio.rpt

prompt Buffer Cache Hit Ratio
select 
	to_char( (sum(decode(name,'consistent gets',value,0)) + sum(decode(name,'db block gets',value,0)) - 
	sum(decode(name,'physical reads',value,0))) / (sum(decode(name,'consistent gets',value,0)) + 
	sum(decode(name,'db block gets',value,0)) ) * 100,999.99)||'%' "hr" 
from 
	v$sysstat
/

prompt Dictionary Cache Hit Ratio
select 
	to_char(
        (1 - (sum(getmisses) / (sum(gets) +     
        sum(getmisses))))*100,999.99)||'%' "hr"
from    
	v$rowcache
/

prompt Library Cache hit ratio
select 
	to_char(
        ((sum(pins) / (sum(pins) + sum(reloads))) * 100),999.99)||'%' "hr"
from 
	v$librarycache
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
