/*
 * Title  : prof_list.sql
 * Author : EXADIME LLC
 * Created: 21-Jan-2026
 * Updated: 21-Jan-2026
 * Release: 1.0.0
 * Purpose: Shows available profiles in the database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 80
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "#"         format 999	heading "#"
col "profile"	format a30	heading "Name"

spool &&rpt_dir/prof_list.rpt

select 
	row_number() over(order by profile) "#",
	profile
from (
	select
		distinct profile
	from 
		dba_profiles 
)
order by 
	2;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 200
set long 80

set termout on
set serverout off
set feedback on
set echo off
