/*
 * Title  : obj_info.sql
 * Author : EXADIME LLC
 * Created: 21-Jan-2026
 * Updated: 21-Jan-2026
 * Release: 1.0.0
 * Purpose: Shows details of the given object.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 200
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 999	heading "#"
col owner		format a30	heading "Owner"
col object_name		format a25	heading "Name"
col object_type		format a25	heading "Type"
col status		format a16	heading "Status"

accept p_object char prompt "Enter object name: "

spool &&rpt_dir/obj_info.rpt

select 
	rownum,
	owner,
	object_name,
	object_type,
	status
from
	dba_objects
where
	object_name=upper('&&p_object');

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
