/*
 * Title  : fb_db_rp.sql
 * Author : EXADIME LLC
 * Created: 09-Dec-2025
 * Updated: 09-Dec-2025
 * Release: 1.0.0
 * Purpose: Flashback database to the given restore point.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_name  char prompt "Enter restore point name: "

spool &&rpt_dir/fb_db_rp.rpt

declare
	v_count number;
	v_cluster char(5);
	v_name varchar2(128) := trim(upper('&&p_name'));
	v_instance varchar2(10);
	v_database varchar2(8);
begin
	if v_name is null or length(v_name) = 0 then
		dbms_output.put_line('Restore point name cannot be empty!');
		goto last;
	end if;
  
	select count(*) into v_count from v$restore_point where name = v_name;
	if v_count = 0 then
		dbms_output.put_line('Restore point ' || v_name || ' does not exist!');
		goto last;
	end if;

	dbms_output.put_line('Run the below commands to perform this operation.');
	
	select value into v_cluster from v$parameter where name='cluster_database';
	select name into v_database from v$database;
	select instance_name into v_instance from v$instance;

	if v_cluster='TRUE' then
		dbms_output.put_line('srvctl stop database -d ' || v_database);
		dbms_output.put_line('srvctl start instance -d ' || v_database || ' -i ' || v_instance || ' -o mount');
	else
		dbms_output.put_line('shutdown immediate');
		dbms_output.put_line('startup mount');
	end if;

	dbms_output.put_line('flashback database to restore point &&p_name;');
	dbms_output.put_line('alter database open resetlogs;');

	<<last>>
	null;
exception
	when others then
		dbms_output.put_line('ERROR: ' || sqlerrm);
		raise;
end;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
