/*
 * Title  : dg_st_stb.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 18-May-2021
 * Release: 1.0.0
 * Purpose: To start standby database and MRP.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_mode char prompt "Enter Open Mode {[M]OUNT|[R]EAD} " default M
accept p_lts  char prompt "Enter Log Transport Service {[A]RCH|[L]GWR} " default A

spool &&rpt_dir/dg_st_stb.rpt

startup nomount
set serverout on

declare
	v_mode varchar2(4):= '&&p_mode';
	v_lts  varchar2(4):= '&&p_lts';
begin
	begin
		execute immediate 'alter database mount standby database';
		dbms_output.put_line('Standy database mounted.');
	exception
		when others then
			dbms_output.put_line('Failed to mount standby database! Details are... ' || chr(10) || SQLERRM );
			goto the_end;
	end;
	
	begin
		if upper(v_mode) = 'R' or upper(v_mode) = 'READ' then
			execute immediate 'alter database open read only';
			dbms_output.put_line('Database opened in read only mode. Starting MRP process...');
		end if;
	exception
		when others then
			dbms_output.put_line('Failed to open standby database! Details are... ' || chr(10) || SQLERRM );
			goto the_end;
	end;

	if upper(v_lts) = 'A' or upper(v_lts) = 'ARCH' then
		execute immediate 'alter database recover managed standby database disconnect from session';
		dbms_output.put_line('MRP started using ARCH.');
	elsif upper(v_lts) = 'L' or upper(v_lts) = 'LGWR' then
		execute immediate 'alter database recover managed standby database using current logfile disconnect from session';
		dbms_output.put_line('MRP started using LGWR.');
	else
		dbms_output.put_line('MRP not started due to wrong input! Use dg_st_mrp.sql to start MRP.');
	end if;

	<<the_end>>
	null;
exception
   when others then
      dbms_output.put_line('Failed to start MRP! Details are... ' || chr(10) || SQLERRM );
end;
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
