/*
 * Title  : dg_sp_stb.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 16-Apr-2021
 * Release: 1.0.0
 * Purpose: To stop MRP and standby database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

spool &&rpt_dir/dg_sp_stb.rpt

declare
	v_mrp number:=0;
begin
	select
		count(1) into v_mrp
	from
		v$managed_standby
	where
		process like 'MRP%';

	if v_mrp > 0 then
		execute immediate 'alter database recover managed standby database cancel';
		dbms_output.put_line('MRP stopped.');
	end if;
exception
	when others then
		dbms_output.put_line('Failed to unmount standby database! Details are... ' || chr(10) || SQLERRM );
end;
/

shutdown immediate;

spool off;

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
