/*
 * Title  : dg_mrp_mode.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 16-Apr-2021
 * Release: 1.0.0
 * Purpose: Shows MRP process mode in standby. Run in primary database.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Dest Id"           format 9999999
col "Recovery Mode"	format a30

spool &&rpt_dir/dg_mrp_mode.rpt

select
	dest_id		"Dest Id",
	recovery_mode 	"Recovery Mode"
from
	v$archive_dest_status
where
	dest_id=2;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
