/*
 * Title  : dg_err.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 03-Oct-2024
 * Release: 1.0.0
 * Purpose: Checks Data Guard error in primary.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "Dest Id"		format 999,999
col "Fail Date"		format a14
col "Curret Log"	format 99,999,999
col "Fail Log"		format 99,999,999
col "Error"		format a65

spool &&rpt_dir/dg_err.rpt

select
	dest_id					"Dest Id",
	to_char(fail_date,'YYYYMMDD HH24:MM')	"Fail Date",
	log_sequence				"Current Log",
	fail_sequence				"Fail Log",
	error					"Error"        
from
	v$archive_dest 
where 
	destination is not null;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
