/*
 * Title  : cr_seq.sql
 * Author : EXADIME LLC
 * Created: 01-Jun-2023
 * Updated: 01-Jun-2023
 * Release: 1.0.0
 * Purpose: Generates sequence creation script for the given sequence.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 10000

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

set serveroutput on
execute dbms_output.enable(10000000);

accept p_owner prompt 'Enter owner name: '
accept p_sequence prompt 'Enter sequence name: '

BEGIN
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'SQLTERMINATOR', true);
   DBMS_METADATA.set_transform_param (DBMS_METADATA.session_transform, 'PRETTY', true);
END;
/

spool &&tmp_dir/cr_seq.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/cr_seq.rpt
prompt 
prompt rem 0.Sequence.
 
select 
	dbms_metadata.get_ddl('SEQUENCE',upper('&&p_sequence'),upper('&&p_owner')) 
from 
	dual;

prompt
prompt rem 1.Grant table privileges.

select 
	'GRANT '|| privilege || ' ON '|| owner || '.' || table_name || ' TO ' || grantee ||';'
from 
	dba_tab_privs
where
	owner=upper('&&p_owner')
and	table_name = upper('&&p_sequence');

prompt
prompt spool off

spool off

prompt Run the script "&&tmp_dir/cr_seq.tmp" manually.
prompt

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
