/*
 * Title  : cr_one_role.sql
 * Author : EXADIME LLC
 * Created: 21-Jan-2026
 * Updated: 21-Jan-2026
 * Release: 1.0.0
 * Purpose: Generates role creation script for the given role.
 * Comment: Only for one role.
 * History: None
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_role char prompt 'Enter Role Name: '

set serveroutput on
execute dbms_output.enable(10000000);

spool &&tmp_dir/cr_one_role.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/cr_one_role.rpt
prompt 

select 
	'grant ' || privilege || ' on ' || owner || '.' || table_name || ' to &&p_role;'
from(
	select 
		owner,
		table_name,
		privilege
       from 
		dba_tab_privs a,
		dba_roles b
       where 
		a.grantee=b.role
       and	
		a.grantee=upper('&&p_role')
);

prompt
prompt spool off

spool off

prompt Run the script "&&tmp_dir/cr_one_role.tmp" manually.
prompt

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
