/*
 * Title  : awr_sql_text.sql
 * Author : EXADIME LLC
 * Created: 25-Apr-2021
 * Updated: 25-Apr-2021
 * Release: 1.0.0
 * Purpose: Shows SQL text for the given sql_id captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 10000

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno              format 9999             heading "#"               
column snid             format 999999           heading "SnapId"
column time             format a15              heading "Time"
column name             format a45              heading "Name"
column aval             format 99,999,999       heading "Average"
column mval             format 99,999,999       heading "Maximum"

accept p_inst_id char prompt "Enter instance Id: " default 1
accept p_bsnap	prompt "Enter Begin Snap Id: "
accept p_esnap	prompt "Enter End Snap Id: "
accept p_sql_id char prompt "Enter SQL Id: "

variable v_dbid number;

begin
select dbid into :v_dbid from v$database;
end;
/

spool &&rpt_dir/awr_sql_text.rpt

select
   *
from
	table (dbms_workload_repository.awr_sql_report_text(:v_dbid, &p_inst_id, &p_bsnap, &p_esnap, '&p_sql_id'));

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off