/*
 * Title  : awr_html_rpt.sql
 * Author : EXADIME LLC
 * Created: 22-Jun-2024
 * Updated: 06-May-2025
 * Release: 1.0.0
 * Purpose: To generate AWR report in html format.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 1000000

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column dbid	format 999999999999	heading "DB Id"
column InstId	format 999999		heading "Instance Id"

variable v_dbid number
variable v_name char(10)
variable v_file char(50)

begin
	select 
		dbid into :v_dbid
	from
		v$database;
	select 
		name into :v_name
	from
		v$database;
end;
/

select 
	distinct instance_number InstId
from
	dba_hist_snapshot
/

set heading off
set trimspool off

accept p_bsnap  number	prompt "Enter Begin Snap Id: "
accept p_esnap  number	prompt "Enter End Snap Id: "
accept p_instid number	prompt "Enter Instance Id: "	default 1

exec	:v_file := 'awr' || '_' || lower(trim(:v_name)) || '_' || &&p_instid || '_' || &&p_bsnap || '_' || &&p_esnap || '.html'

column file_name new_value spool_file noprint

select :v_file as file_name from dual;	

spool &&awr_dir/&&spool_file

select 
	output 
from 
	table(dbms_workload_repository.awr_report_html(:v_dbid, &&p_instid, &&p_bsnap, &&p_esnap))
/

spool off;

prompt Report file is... "&&awr_dir/&&spool_file".

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
