/*
 * Title  : awr_bw_hist.sql
 * Author : EXADIME LLC
 * Created: 01-Jan-2018
 * Updated: 01-Jan-2018
 * Release: 1.0.0
 * Purpose: Shows bandwidth usage history captured in awr.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column "Serial Number"	format a3
column snid		format 999999		heading "SnapId"
column time		format a15		heading "Time"
column value		format 999		heading "Mbps|Bandwidth"

accept p_bsnap	prompt "Enter Begin Snap Id: "
accept p_esnap	prompt "Enter End Snap Id: "
accept p_order	prompt "Enter sort order [asc|desc]: "

spool &&rpt_dir/awr_bw_hist.rpt

select
	row_number() over(order by snap_id &&p_order)		"#",
	snap_id							snid,
	to_char(snaptime,'yyyymmdd hh24:mi')			time,
	ceil(value)						value
from 
	(
		select 
			s.snap_id,
			s.begin_interval_time		snaptime,
			((max(value)/0.7)*8)/1000000	value
		from 
			dba_hist_snapshot s, dba_hist_sysmetric_history t
		where
			s.snap_id = t.snap_id
		and	s.instance_number = t.instance_number 
		and	s.dbid = t.dbid
		and	s.instance_number = (select instance_number from v$instance)
		and	s.dbid = (select dbid from v$database)
		and	t.metric_id = 2016
		and	s.snap_id between &p_bsnap and &p_esnap
		group by
			s.snap_id,
			s.begin_interval_time
		order by
			s.snap_id desc
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off