/*
 * Title  : asm_info.sql
 * Author : EXADIME LLC
 * Created: 17-Dec-2025
 * Updated: 17-Dec-2025
 * Release: 1.0.0
 * Purpose: Shows ASM disk group information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column dummy     noprint
column sno       format 9999            heading "#"
column name      format a25             heading "Name"
column com       format a13		heading "Compatibility"
column au        format 99,999,999	heading "AU"
column type      format a6              heading "Type"
column state     format a11		heading "State"

accept p_txt char prompt "Enter search string (E.g. DATA): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc] " default 2

spool &&rpt_dir/asm_info.rpt

select
	row_number() over(order by &&p_order)      sno,
	name                                       name,
	compatibility                              com,
	allocation_unit_size			   au,
	type                                       type,
	state                                      state
from(
	select 
		name,
		compatibility,
		allocation_unit_size,
		type,
		state
	from 
		v$asm_diskgroup
	where (name like trim(upper('%&&p_txt%')) or type like trim(upper('%&&p_txt%')) or state like trim(upper('%&&p_txt%')))
)
order by
	&&p_order
/

spool off

clear columns
clear computes

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off