//Usage: java testSSL <database properties> <wallet properties>
//Example: java testSSL database.properties {ewallet.properties|cwallet.properties|keystore.properties}
//
//***************************************************************
//database.properties
//user=scott
//password=tiger
//URL=jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcps)\
//      (HOST=L000019.exadime.com)(PORT=1526))\
//      (CONNECT_DATA=(SERVICE_NAME=orcl.exadime.com)))
//
//ewallet.properties
//javax.net.ssl.keyStore=/home/oracle/wallet/ssl/ewallet.p12
//javax.net.ssl.keyStoreType=PKCS12
//javax.net.ssl.keyStorePassword=Welcome1
//
//cwallet.properties
//javax.net.ssl.trustStore=/home/oracle/wallet/ssl/cwallet.sso
//javax.net.ssl.trustStoreType=SSO
//
//keystore.properties
//javax.net.ssl.trustStore=/home/oracle/wallet/jks/store.jks
//javax.net.ssl.trustStoreType=JKS
//javax.net.ssl.trustStorePassword=Welcome1
//**************************************************************
//Add the following jar files to the class path taken from host.
//Stand Alone
//ojdbc8.jar from Oracle website.
//$ORACLE_HOME/jlib/oraclepki.jar
//$ORACLE_HOME/jlib/osdt_cert.jar
//$ORACLE_HOME/jlib/osdt_core.jar
//Real Application Clusters
//$ORACLE_HOME/opmn/lib/ons.jar
//$ORACLE_HOME/ucp/lib/ucp.jar
//Note: All these files are not available in the Oracle client.
//**************************************************************

import java.io.*;
import java.util.*;
import java.sql.*;
import java.security.*;
import oracle.jdbc.driver.OracleDriver;
import oracle.security.pki.OraclePKIProvider;

public class testSSL {
	public static void main(String[] args)
	throws ClassNotFoundException, IOException, SQLException{
		try {
			//Database & Wallet Information
			Properties properties = new Properties();
			Properties database = new Properties();
			Properties wallet = new Properties();

			database.load(new FileInputStream(args[0]));
			wallet.load(new FileInputStream(args[1]));

			properties.putAll(database);
			properties.putAll(wallet);

			//Database Connection
            DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
            Connection conn = DriverManager.getConnection(properties.getProperty("URL"),properties);
            conn.setAutoCommit(false);

			//Database Query
			Statement stmt = conn.createStatement();
			ResultSet rset = stmt.executeQuery("select * from dept");
			while (rset.next()) {
					System.out.println(rset.getInt(1)+"  "+rset.getString(2)+"  "+rset.getString(3));
			}
			ResultSet tcps = stmt.executeQuery("select sys_context('USERENV','network_protocol') from dual");
			while (tcps.next()) {
				System.out.println("Protocol: " + tcps.getString(1));
			}
			stmt.close();
			conn.close();
		} catch (ArrayIndexOutOfBoundsException a) {
			System.out.println("Usage: java testSSL <database properties> <wallet properties>");
		} catch (FileNotFoundException file) {
			System.out.println("Property file missing!");
		} catch (SQLException sql) {
			sql.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
   }
}
