/*
 * Title  : stat_task_list.sql
 * Author : EXADIME LLC
 * Created: 24-Jun-2024
 * Updated: 24-Jun-2024
 * Release: 1.0.0
 * Purpose: To check client/task for the given gathering job window.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col rownum		format 99	heading "#"
col client_name		format a32	heading "Name"
col client_tag		format a3	heading "Tag"
col window_group	format a15	heading "Window Group"
col status		format a10	heading "Status"

spool &&rpt_dir/stat_task_list.rpt

select 
	rownum,
	client_name,
	client_tag,
	window_group,
	status
from 
	dba_autotask_client;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
