/*
 * Title  : stat_job_stop.sql
 * Author : EXADIME LLC
 * Created: 06-Jul-2017
 * Updated: 06-Jul-2017
 * Release: 1.0.0
 * Purpose: To stop statistics gathering job.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

variable v_job char(30)

spool &&rpt_dir/stat_job_stop.rpt

begin
	select 
		job_name into :v_job
	from 
		dba_autotask_client_job
	where 
		client_name='auto optimizer stats collection' 
	and	job_scheduler_status='RUNNING';
end;
/

exec dbms_scheduler.stop_job(job_name => :v_job, force => true);

prompt If the above command does not work, use the following sql to clear all associated child jobs.
prompt select 'exec dbms_scheduler.stop_job(job_name =>'''||job_name||''',force=>true);' from dba_scheduler_running_jobs;
prompt Close Window manually. EXECUTE DBMS_SCHEDULER.CLOSE_WINDOW ('<WINDOW_NAME>');

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off