/*
 * Title  : sho_sch_lock.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 31-Jul-2017
 * Release: 1.0.0
 * Purpose: This script shows sessions info for the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 120
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column "Owner"		format a30
column "Object Name"	format a30
column "Object Type"	format a20
column "Lock Type"	format a9
column "Lock Mode"	format a20
column "SID"		format 9999

accept p_own char prompt "Enter Owner "

spool &&rpt_dir/sho_obj_lock.rpt

select 
	o.owner				"Owner",
	o.object_name			"Object Name", 
	o.object_type			"Object Type", 
	l.type				"Lock Type",
	decode(
		l.lmode,
		0, 'None',
		1, 'Null',
		2, 'Row Share',
		3, 'Row Exclusive',
		4, 'Share',
		5, 'Shared Row Exclusive',
		6, 'Exclusive', 
		'Null'
	)				"Lock Mode",
	l.sid				"SID"
from
	dba_objects o,
	v$lock l
where 
	l.id1=+o.object_id
and	o.owner='&&p_own'
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
