/*
 * Title  : sho_redo_file.sql
 * Author : EXADIME LLC
 * Created: 09-Jul-2025
 * Updated: 09-Jul-2025
 * Release: 1.0.0
 * Purpose: Shows redo log files.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno		format 9999	heading "#"
column inst_id		format 999,999	heading "Node"
column group#		format 999,999	heading "Group"
column member		format a70	heading "Member"
column type		format a10	heading "Type"
column status		format a10	heading "Status"

accept p_txt char prompt "Enter search string (E.g. ONLINE|STANDBY): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc] " default 2,3

spool &&rpt_dir/sho_redo_file.rpt

select
	row_number() over(order by &&p_order)	sno,
	inst_id,
	group#,
	member,
	type,
	status
from
	gv$logfile
where
	(type like upper('%&&p_txt%') or status like upper('%&&p_txt%'))
order by
	&&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
