/*
 * Title  : sho_nsp.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: Shows Non System Profiles (11g).
 * History: N/A
 */

start oracle.ini
start oracle.ini

set echo off
set feedback off
set serverout on

set linesize 80
set pagesize 200

set heading on
set headsep on
set underline on
set colsep " "

set verify off
set escape off
set embedded on

col "Profile Name"		format a30

spool &&rpt_dir/sho_nsp.rpt

select 
	distinct profile	"Profile Name"
from
	dba_profiles
where
	profile not in (
		'DEFAULT'
	)
order by
	1
/

spool off;

clear columns

set embedded off
set escape off
set verify on

set colsep " "
set underline on
set headsep on
set heading on

set pagesize 24
set linesize 80

set serverout off
set feedback on
set echo off
