/*
 * Title  : sho_gg_scn.sql
 * Author : EXADIME LLC
 * Created: 20-Sep-2017
 * Updated: 20-Sep-2017
 * Release: 1.0.0
 * Purpose: Shows SCN that can be used to start Golden Gate extract.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column name		format a10	heading "DB Name"
column time	 	format a18	heading "DB Time"
column scn		format a25	heading "Golden Gate SCN"

spool &&rpt_dir/sho_gg_scn.rpt

select
	(
		select
			name
		from
			v$database
	) name,
	(
		select
			to_char(sysdate,'mon dd, yyyy hh24:mi')
		from
			dual
	) time,
	nvl(
		(
			select 
				to_char(current_scn) 
			from 
				v$database
			where (
				(
					select 
						nvl( 
							( 
								select 
									max(username)
								from 
									gv$session s, gv$transaction t
								where 
									t.ses_addr = s.saddr
								and 
									t.inst_id = s.inst_id
							),'ok'
						)
					from 
						dual
				) = 'ok'
			)
		),
		'Open transactions exist!'
	) scn
from  
	dual;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off