/*
 * Title  : sho_db_time.sql
 * Author : EXADIME LLC
 * Created: 01-May-2018
 * Updated: 01-May-2018
 * Release: 1.0.0
 * Purpose: shows the database current time in 100th's of a second.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 100
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column  name		format a8		heading "DB Name"
column	time		format a21		heading "DB Time"
column  fraction	format 9999999999	heading "Fraction"

select
	name,
	to_char(sysdate,'Mon dd, yyyy hh:mi AM') time,
	dbms_utility.get_time fraction
from
	v$database;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
