/*
 * Title  : sho_act_sort.sql
 * Author : EXADIME LLC
 * Created: 20-Mar-2018
 * Updated: 20-Mar-2018
 * Release: 1.0.0
 * Purpose: To display the active sorts information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 50
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

spool &&rpt_dir/sho_act_sort.rpt

select
	username,
	tablespace,
	contents,
	extents,
	blocks
from
	v$session a,
	v$sort_usage b
where
	a.saddr=b.session_addr;	
	
spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
