/*
 * Title  : sch_row_cnt.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 30-Apr-2021
 * Release: 1.0.0
 * Purpose: To count the number of rows of each table in the given schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_owner prompt 'Enter Owner: '

spool &&tmp_dir/sch_row_cnt.tmp

select 
	'select rpad('''||table_name|| ''',30), count(*) from &&p_owner' || '.' || table_name || ';' 
from 
	dba_tables
where
	owner=upper('&&p_owner')
and	iot_type is null
order by
	table_name;

spool off;

cl scr;

spool &&rpt_dir/sch_row_cnt.rpt

@@&&tmp_dir/sch_row_cnt.tmp

spool off;

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off

