/*
 * Title  : sch_obj_gra.sql
 * Author : EXADIME LLC
 * Created: 31-Jul-2017
 * Updated: 29-Jan-2021
 * Release: 1.0.0
 * Purpose: This script provides object grants from source schema to the given target schema.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_source char prompt 'Enter source schema name: '
accept p_target char prompt 'Enter target schema name: '

accept p_privilege char prompt 'Enter the privilege(s) (SELECT|INSERT|UPDATE|DELETE) separated by comma (,) to be granted: '

spool &&tmp_dir/sch_obj_gra.tmp

prompt spool &&rpt_dir/sch_obj_gra.rpt

select
	'grant ' || 
	decode(
		object_type,'TABLE','&&p_privilege',
		'VIEW','select',
		'SEQUENCE','select',
		'FUNCTION','execute',
		'PROCEDURE','execute',
		'PACKAGE','execute'
	) ||
	' on ' || lower(owner) || '.' || lower(object_name) || ' to ' || lower('&&p_target')|| ';' 
from
	dba_objects
where
	object_type in (
		'TABLE',
		'VIEW',
		'SEQUENCE',
		'FUNCTION',
		'PROCEDURE',
		'PACKAGE'
	)
and	owner=upper('&&p_source');

prompt spool off

spool off

prompt Run the script "&&tmp_dir/sch_obj_gra.tmp" manually.
prompt Note: Please verify before you run and edit if required!
prompt 

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
