/*
 * Title  : rmn_reco_time.sql
 * Author : EXADIME LLC
 * Created: 08-Sep-2021
 * Updated: 08-Sep-2021
 * Release: 1.0.0
 * Purpose: Shows the last successful RMAN backup time.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sk	format 99999999999      heading "Session Key"
column it	format a12              heading "Backup Type"
column st	format a19              heading "Start Time"
column et	format a19              heading "End Time"
column ti	format a11              heading "Time"
column sz	format a10		heading "Size"
column sts	format a23              heading "Status"

spool &&rpt_dir/rmn_reco_time.rpt

select
       session_key                                 sk,
       input_type                                  it,
       to_char(start_time,'yyyy-mm-dd hh24:mi:ss') st,
       to_char(end_time,'yyyy-mm-dd hh24:mi:ss')   et,
       time_taken_display                          ti,
       output_bytes_display                        sz,
       status                                      sts
from (
	select 
	       session_key,
	       input_type,
	       start_time,
	       end_time,
	       time_taken_display,
	       output_bytes_display,
	       status
	from 
		v$rman_backup_job_details
	where
		status='COMPLETED'
	order by 
		session_key desc
)
where
	rownum=1;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
