/*
 * Title  : gen_sch_ro.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 29-Jul-2017
 * Release: 1.0.0
 * Purpose: This script makes schema read only.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

execute dbms_output.enable(10000000);

accept p_schema char prompt "Enter Schema Name: "

spool &&tmp_dir/gen_sch_ro.tmp

prompt set feedback on echo on
prompt spool &&rpt_dir/gen_sch_ro.rpt
prompt

select
	'ALTER TABLE ' || upper('&&p_schema') || '.' || object_name || ' READ ONLY;'
from
	dba_objects
where
	object_type in ('TABLE')
and	owner = upper('&&p_schema')
/

prompt
prompt spool off

spool off

prompt Run the script "&&tmp_dir/gen_sch_ro.tmp" manually.
prompt

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
