/*
 * Title  : flush_sql.sql
 * Author : EXADIME LLC
 * Created: 11-Sep-2021
 * Updated: 11-Sep-2021
 * Release: 1.0.0
 * Purpose: To flush SQL from the shared pool.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sql_id  char prompt "Enter SQL Id: "

spool &&rpt_dir/flush_sql.rpt

begin
	for i in (
		select 
				address, 
				hash_value
		from 
				gv$sqlarea
		where 
				sql_id = '&&p_sql_id.'
	) loop
		sys.dbms_shared_pool.purge(i.address||','||i.hash_value, 'C');
	end loop;
end;
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off