/*
 * Title  : dg_info.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 16-Apr-2021
 * Release: 1.0.0
 * Purpose: To display data guard information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 24
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

col "DB Name"			format a8
col "DB Unique Name"            format a15
col "DB Role"                   format a16
col "Open Mode"                 format a10
col "Switchover Status"         format a18
col "Protection Mode"           format a20
col "Protection Level"          format a20
col "Flashback?"                format a18
col "Broker?"                   format a8

spool &&rpt_dir/dg_info.rpt

select
      name                     "DB Name",
      db_unique_name           "DB Unique Name",
      database_role            "DB Role",
      open_mode                "Open Mode",
      switchover_status        "Switchover Status",
      protection_mode          "Protection Mode",
      protection_level         "Protection Level",
      flashback_on             "Flashback?",
      dataguard_broker         "Broker?"   
from
      v$database;

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
