/*
 * Title  : awr_tbs_day_hist.sql
 * Author : EXADIME LLC
 * Created: 15-Mar-2024
 * Updated: 15-Mar-2024
 * Release: 1.0.0
 * Purpose: Shows tablespace growth by each day captured in AWR.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	 format 99999		heading "#"
column day	 format a10		heading "Day"
column snid	 format 999999		heading "SnapId"
column time	 format a20		heading "Snap Time"
column name	 format a25		heading "Tablespace Name"
column total	 format 99,999,999,999	heading "Total"
column alloc	 format 99,999,999,999	heading "Allocated"
column used	 format 99,999,999,999	heading "Used"
column free	 format 99,999,999,999	heading "MBytes|Free"
column pct_used	 format 999.99		heading "%|Used"

accept p_tbs_name char prompt "Enter tablespace name: "
accept p_order char prompt "Enter display order [asc|desc]: " default asc
accept p_rows  char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/awr_tbs_day_hist.rpt

select
	row_number() over(order by 2 &&p_order) sno,
	day,
	total,
	alloc,
	used,
	free,
	pct_used
from (
	select
		substr(a.rtime,1,10)											day,
		sum(a.tablespace_maxsize*c.block_size/1024/1024)							total,
		sum(a.tablespace_size*c.block_size/1024/1024)						 		alloc,
		sum(a.tablespace_usedsize*c.block_size/1024/1024)						 	used,
		sum((a.tablespace_maxsize-a.tablespace_usedsize)*c.block_size/1024/1024)		 		free,
		sum(a.tablespace_usedsize*c.block_size/1024/1024)*100/sum(a.tablespace_maxsize*c.block_size/1024/1024) 	pct_used
	from
		dba_hist_tbspc_space_usage a,
		v$tablespace b,
		dba_tablespaces c
	where
		a.tablespace_id=b.ts#
	and	b.name=c.tablespace_name
	and	b.name=upper('&p_tbs_name')
	and	a.snap_id in (select snap_id from dba_hist_snapshot where to_char(begin_interval_time,'HH24:MI')='00:00')
	group by
		substr(a.rtime,1,10)
	order by 
		to_date(substr(a.rtime,1,10),'MM/DD/YYYY') &&p_order
)
where
	rownum<=&&p_rows
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
