#-/*
#- Title  : set_db_env.ksh
#- Author : EXADIME LLC
#- Created: 29-Jun-2017
#- Updated: 27-Oct-2020
#- Release: 1.0.0
#- Purpose: This script sets database environment of the given sid or selected sid.
#- History: This is a clone of mnt_sw_db.ksh and created to work as stand-alone.
#- Comment: Run/embed with full path. E.g. $. /home/oracle/scripts/exa/unix/set_db_env.ksh [sid].
#-*/

#0.Shell
#!/usr/bin/ksh

if [ "`uname -a|cut -b1-5`" = "SunOS" ]; then
	ora_tab=/var/opt/oratab
else
	ora_tab=/etc/oratab
fi

#Header
#1.Input
if [ "${#}" -gt "1" ]; then
	echo "Too many arguments!"
	echo "Usage: ksh mnt_sw_db.ksh [sid]"
	return
fi

#2.Sanity Checks
#2.1.Check for oratab.
if ! [ -f ${ora_tab} ]
then
	echo "oratab file does not exist!"
	return
fi

#2.2.Check for entries in oratab.
if test `grep -v '^#' ${ora_tab}|grep '^[^ ]'|grep -v '^-'|cut -f1 -d:|awk '{print;exit}'|wc -l` -ne 1
then
	echo "oratab file is blank!"
	return
fi

#2.3.Check for entry in oratab.
if [ "${#}" -eq "1" ]; then
	for i in `grep -v '^#' ${ora_tab}|grep '^[^ ]'|grep -v '^-'|grep ${1}`
	do
		a=`echo ${i}|awk -F: '{print $1}'`
		b=`echo ${i}|awk -F: '{print $2}'`
		
		if [ "${a}" = "${1}" ]
		then
			f=1
		fi
	done

	if [ ! "${f}" = "1" ]
	then
		echo "No entry found in oratab file for ${1}!"
		return
	fi
fi

#2.4.Validate entry in oratab.
if [ "${#}" -eq "1" ]; then
	for i in `grep -v '^#' ${ora_tab}|grep '^[^ ]'|grep -v '^-'|grep ${1}`
	do
		a=`echo ${i}| awk -F: '{print $1}'`
		b=`echo ${i}| awk -F: '{print $2}'`
		
		if [ "${a}" = "${1}" ]
		then
			if [[ "${b}" = "" || ! -d ${b} ]]
			then
				echo "Oracle home does not exist for oratab entry ${1}!"
				return
			fi
		fi	
	done
fi

#Body
#1.Set ORACLE_SID.
if [ "$#" != "0" ]
then
	ORACLE_SID=${1}
	shift
	export ORACLE_SID
else
	echo "Here are the databases on `hostname`, your sid is currently ${ORACLE_SID}."
	PS3='Which database would you like to switch to? '
	select ORACLE_SID in `grep -v '^#' ${ora_tab}|grep '^[^ ]'|grep -v '^-'|cut -f1 -d:`
	do
		break
	done
	
	if [ "${ORACLE_SID}" = "" ]; then
		echo "Wrong selection! Try again."
		return
	else
		export ORACLE_SID
	fi
fi

#2.Set ORACLE_HOME and replace old home in PATH.
if [ ${ORACLE_HOME:-0} = 0 ]; then
    OLDHOME=${PATH}
else
    OLDHOME=${ORACLE_HOME}
fi

for i in `grep -v '^#' ${ora_tab}|grep '^[^ ]'|grep -v '^-'|grep ${ORACLE_SID}`
do
	a=`echo ${i}|awk -F: '{print $1}'`
	b=`echo ${i}|awk -F: '{print $2}'`
	
	if [ "${a}" = "${ORACLE_SID}" ]
	then
		ORACLE_HOME=${b}; export ORACLE_HOME
	fi
done

case "${OLDHOME}" in
    "")	OLDHOME=${PATH} ;;	#This makes it so that null OLDHOME can't match
esac				#anything in next case statement

case "${PATH}" in
    *${OLDHOME}/*)	PATH=`echo ${PATH} | \
			    sed "s;${OLDHOME}/;${ORACLE_HOME}/;g"` ;;
    *${ORACLE_HOME}/bin*)	;;
    *:)			PATH=${PATH}${ORACLE_HOME}/bin: ;;
    "")			PATH=${ORACLE_HOME}/bin ;;
    *)			PATH=${PATH}:${ORACLE_HOME}/bin ;;
esac

export PATH 

#3.Set ORACLE_BASE.
if [ "${ORACLE_BASE}" = "" ]; then
	ORACLE_BASE=`dirname ${ORACLE_HOME}`; export ORACLE_BASE
fi

#4.Locate "osh" and exec it if found.
ULIMIT=`LANG=C ulimit 2>/dev/null`

if [ $? = 0 -a "${ULIMIT}" != "unlimited" ] ; then
  if [ "${ULIMIT}" -lt 2113674 ] ; then

    if [ -f ${ORACLE_HOME}/bin/osh ] ; then
	exec ${ORACLE_HOME}/bin/osh
    else
	for D in `echo ${PATH} | tr : " "`
	do
	    if [ -f ${D}/osh ] ; then
		exec ${D}/osh
	    fi
	done
    fi

  fi

fi

#5.Set LD_LIBRARY_PATH.
LD_LIBRARY_PATH=${ORACLE_HOME}/lib:/usr/openwin/lib:/usr/local/lib:/usr/lib:/usr/dt/lib; export LD_LIBRARY_PATH

#6.Set TNS_ADMIN.
if [ "${TNS_ADMIN}" = "" ]
then
	if ! [ -f ${TNS_ADMIN}/tnsnames.ora ]
	then
		TNS_ADMIN=${ORACLE_HOME}/network/admin; export TNS_ADMIN
	fi
fi

#7.Set NLS_LANG.
NLS_LANG=AMERICAN_AMERICA.WE8ISO8859P1; export NLS_LANG

#8.Set OPatch location in PATH.
if [ "`echo ${PATH}|grep ${ORACLE_HOME}/OPatch`" = "" ]
then
	PATH=${PATH}:${ORACLE_HOME}/OPatch; export PATH
fi

#9.Set custom values.
#. dba.env

#10.Display message.
echo "Switched to $ORACLE_SID db env."
