/*
 * Title  : top_cur_ses.sql
 * Author : EXADIME LLC
 * Created: 06-Jul-2017
 * Updated: 06-Jul-2017
 * Release: 1.0.0
 * Purpose: Shows details of top open cursor sessions.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum		format 9999		heading "#"
column sid		format 9999		heading "SID"
column serial#		format 99999999		heading "Serial#"
column username		format a30		heading "User Name"
column machine		format a30		heading "Machine"
column sql_id		format a15		heading "SQL Id"
column status		format a10		heading "Status"
column value		format 9,999,999,999	heading "Cursors"

accept p_top	prompt "Enter top rows [10]: " default 10;

spool &&rpt_dir/top_cur_ses.rpt

select
	rownum,
	sid,
	serial#,
	username,
	machine,
	sql_id,
	status,
	value
from (
	select 
		s.sid,
		s.serial#,
		s.username,
		s.machine,
		s.sql_id,
		s.status,
		ss.value
	from 
		v$sesstat ss,
		v$statname sn,
		v$session s
	where 
		ss.statistic# = sn.statistic#
	and	sn.name like '%opened cursors current%'
	and	s.sid=ss.sid
	order by
		ss.value desc
)
where
	rownum<=&&p_top
order by
	value desc;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off