/*
 * Title  : stat_win_list.sql
 * Author : EXADIME LLC
 * Created: 16-Oct-2021
 * Updated: 16-Oct-2021
 * Release: 1.0.0
 * Purpose: Shows all available schedular windows.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 250
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno              format 999      heading "#"
column window_name	format a18	heading "Window Name"
column repeat_interval	format a70	heading "Interval"
column duration		format a15	heading "Duration"
column window_priority	format a10      heading "Priority"
column nextstartdate	format a40      heading "Next Start Date"
column laststartdate	format a40      heading "Last Start Date"

spool &&rpt_dir/stat_win_list.rpt

select 
	rownum sno,
	t.*
from(
	select 
		window_name, 
		repeat_interval,
		duration, 
		window_priority,
		to_char(next_start_date, 'MM-DD-YYYY HH:MI:SS AM tzr') nextstartdate,
		to_char(last_start_date, 'MM-DD-YYYY HH:MI:SS AM tzr') laststartdate
	from 
		dba_scheduler_windows
	) t
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
