/*
 * Title  : sp_snap_list.sql
 * Author : EXADIME LLC
 * Created: 29-Jul-2017
 * Updated: 15-Jul-2024
 * Release: 1.0.0
 * Purpose: Statspack Snapshots
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum		format 99999		heading "#"
column snapid		format 9999999		heading "Snap Id"
column instid		format 9999999		heading "Inst Id"
column snaptime		format a15		heading "Snap Time"

accept p_days char prompt "Enter number of days: " default 1
accept p_inst char prompt "Enter instance number: " default 1
accept p_disp char prompt "Enter display order {ASC|DESC}: "

spool &&rpt_dir/sp_snap_list.rpt

select
	rownum,
	snapid,
	instid,
	snaptime
from (
	select 
		snap_id		snapid,
		instance_number	instid,
		to_char(snap_time,'yyyymmdd hh24:mi') snaptime
	from 
		stats$snapshot,
		v$database
	where     
		snap_time>sysdate-&p_days
	and     instance_number=&&p_inst
	order by
		snap_id &p_disp
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
