/*
 * Title  : sho_tde_tbs.sql
 * Author : EXADIME LLC
 * Created: 13-Nov-2023
 * Updated: 13-Nov-2023
 * Release: 1.0.0
 * Purpose: Shows encrypted tablespaces details.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 999		heading "#"
column name	format a30		heading "Tablespace Name"
column alg 	format a10		heading "Algorithm"
column enc	format a10		heading "Encrypted?"

accept p_order char prompt "Enter order by column {1|2|3|4} [asc|desc] " default 2

spool &&rpt_dir/sho_tde_tbs.rpt

select 
	row_number() over(order by &&p_order)                   sno,
	name							name, 
	encryptionalg						alg,
	encryptedts						enc
from (
	select 
		t.name,
		e.encryptionalg,
		encryptedts
	from
		v$tablespace t, v$encrypted_tablespaces e 
	where
		t.ts# = e.ts#
	and	encryptedts='YES'
) order by 
	&&p_order
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
