/*
 * Title  : sho_sga_adv.sql
 * Author : EXADIME LLC
 * Created: 31-Aug-2021
 * Updated: 31-Aug-2021
 * Release: 1.0.0
 * Purpose: Shows SGA Advisory recommendations.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 250
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum				format 9999             heading "#" 
column sga_size				format 999,999		heading "Bytes|SGA Size"
column sga_size_factor			format 990.00		heading "SGA Factor"
column estd_db_time			format 99999999		heading "DB Time"
column estd_db_time_factor		format 990.00		heading "DB Time Factor"
column estd_buffer_cache_size		format 99999999		heading "Buffer Cache"               
column estd_shared_pool_size		format 99999999		heading "Shared Pool"        
column estd_physical_reads		format 999,999,999,999	heading "Physical Reads"           

spool &&rpt_dir/sho_sga_adv.rpt

select 
	rownum,
	sga_size_factor,                                    
	estd_db_time,                                       
	estd_db_time_factor,                                
	estd_buffer_cache_size,                             
	estd_shared_pool_size,                                                    
	estd_physical_reads,
	sga_size
from 
	v$sga_target_advice
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 250
set long 80

set termout on
set serverout off
set feedback on
set echo off
