/*
 * Title  : sho_role_user.sql
 * Author : EXADIME LLC
 * Created: 14-Sep-2025
 * Updated: 14-Sep-2025
 * Release: 1.0.0
 * Purpose: Lists all the users having the given role.
 * Comment: none
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_role char prompt 'Enter Role Name: '

col sno		format 999	heading "#"
col grantee	format a30	heading "Grantee"

spool &&rpt_dir/sho_role_user.rpt

select 
        rownum sno,
        grantee
from (  
	select
		grantee
	from
		dba_role_privs a,
		dba_users b
	where 
		a.grantee=b.username
	and
		granted_role=upper('&&p_role')
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
