/*
 * Title  : sho_mem_dtl.sql
 * Author : EXADIME LLC
 * Created: 27-Ocat-2016
 * Updated: 04-Apr-2018
 * Release: 1.0.0
 * Purpose: Query v$memory_dynamic_components. Show sizes in KB.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 99		heading "#"
column cpnt	format a25		heading "Component"
column csz	format 999,999,999	heading "Cur Size"
column msz	format 999,999,999	heading "Min Size"
column mxsz	format 999,999,999	heading "KBytes|Max Size"

break on report

spool &&rpt_dir/sho_mem_dtl.rpt

select 
	rownum				sno,
	component			cpnt,
	current_size/1000		csz,
	min_size/1000			msz,
	max_size/1000			mxsz
from 
	v$memory_dynamic_components
where
	current_size<>0
and	min_size<>0
and	max_size<>0;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
